package tests;

import javax.swing.JFrame;

import model.Board;
import model.MineException;
import model.generators.ConcreteBoardGenerator;
import view.BoardView;
import view.SimpleBoxDrawer;

public class BoardViewTest {

	public static void main(String[] args) throws MineException {
		
		JFrame frame = new JFrame();
		frame.setVisible(true);
		Board board=new Board(new ConcreteBoardGenerator(10, 20));
		frame.getContentPane().add(new BoardView(board, new SimpleBoxDrawer(30)));
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
}
